<?php
    use Illuminate\Support\Str;
    // Ambil semua contoh dari seluruh kategori pada menu ini
    $allContoh = $menu->contents->flatMap(function($content) {
        return $content->contohs;
    });
    $jumlahContoh = $allContoh->count();
    $activeCategory = $categories->first();
    $firstContent = $activeCategory ? $menu->contents->where('category_id', $activeCategory->id)->first() : null;
    $defaultCategory = $allCategories->first();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title>Detail Menu</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        html, body {
            height: 100%;
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            max-width: 100vw;
            overflow-x: hidden;
        }
        body {
            background: #fff;
            min-height: 100vh;
            min-width: 100vw;
            max-width: 100vw;
            overflow-x: hidden;
        }
        .main-wrapper {
            display: flex;
            flex-direction: column;
            min-height: 100vh;
            width: 100%;
            max-width: 100%;
            background: #fff;
            overflow-x: hidden;
        }
        .custom-header {
            position: relative;
            padding: 56px 0 0 0;
            text-align: center;
            background: #fff;
        }
        .user-avatar {
            position: absolute;
            top: 16px;
            right: 32px;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: #e0e0e0;
            display: flex;
            align-items: center;
            justify-content: center;
            border: 2px solid #DEF8D2;
        }
        .user-avatar .material-icons {
            font-size: 32px;
            color: #DEF8D2;
        }
        .main-title {
            font-weight: bold;
            font-size: 1.5rem;
            margin-bottom: 0.25rem;
            color: #222;
            word-break: break-word;
        }
        .main-desc {
            color: #444;
            font-size: 1rem;
            margin-bottom: 1.5rem;
            word-break: break-word;
        }
        .tab-btn-group {
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
            gap: 16px;
            margin-bottom: 0.5rem;
            background: #fff;
            position: relative;
        }
        .tab-btn-wrapper {
            display: flex;
            align-items: center;
            gap: 4px;
            position: relative;
        }
        .tab-btn-actions {
            display: flex;
            gap: 2px;
            opacity: 0;
            transition: opacity 0.2s;
        }
        .tab-btn-wrapper:hover .tab-btn-actions {
            opacity: 1;
        }
        .tab-btn-actions .icon-btn {
            background: none;
            border: none;
            padding: 2px 4px;
            color: #6c757d;
            cursor: pointer;
            font-size: 18px;
            display: flex;
            align-items: center;
            border-radius: 4px;
            transition: background 0.2s, color 0.2s;
        }
        .tab-btn-actions .icon-btn:hover {
            background: #f3eaff;
            color: #4c14e4;
        }
        .tab-btn {
            min-width: 70px;
            font-size: 1.1rem;
            font-weight: bold;
            background:rgb(139, 4, 121);
            border: 2px solid #DEF8D2;
            border-radius: 8px;
            color: #DEF8D2;
            padding: 2px 0.5em;
            transition: background 0.2s;
        }
        .tab-btn.active, .tab-btn:focus {
            background:rgb(76, 20, 228);
            color: #fff;
        }
        .content-area {
            background:rgb(188, 241, 163);
            border-radius: 40px 40px 0 0;
            flex: 1 1 auto;
            min-height: 0;
            padding: 24px 4px;
            color: #DEF8D2;
            display: flex;
            flex-direction: column;
            max-width: 100%;
            overflow-x: hidden;
        }
        .category-content {
            width: 100%;
            overflow-wrap: break-word;
            word-break: break-word;
        }
        @media (max-width: 576px) {
            .content-area {
                padding: 8px 0;
            }
            .main-title {
                font-size: 1.1rem;
            }
            .main-desc {
                font-size: 0.95rem;
            }
            .tab-btn {
                font-size: 0.95rem;
                min-width: 60px;
                padding: 2px 0.3em;
            }
        }
        @media (max-width: 400px) {
            .main-title {
                font-size: 1rem;
            }
            .main-desc {
                font-size: 0.85rem;
            }
            .tab-btn {
                font-size: 0.85rem;
                min-width: 50px;
            }
        }
        .edit-btn {
            background: rgb(76, 20, 228) !important;
            border: none !important;
            padding: 4px 12px !important;
            font-size: 12px !important;
            border-radius: 4px !important;
            color: white !important;
            text-decoration: none !important;
            display: inline-flex !important;
            align-items: center !important;
            gap: 4px !important;
            transition: opacity 0.2s !important;
        }
        .edit-btn:hover {
            opacity: 0.8;
            color: white !important;
        }
        .content-item {
            display: flex !important;
            justify-content: space-between !important;
            align-items: center !important;
            margin-bottom: 10px !important;
            padding: 8px 0 !important;
            word-break: break-word;
            overflow-wrap: break-word;
            white-space: normal !important;
        }
        .content-title {
            flex: 1 !important;
            margin-right: 10px !important;
            overflow-wrap: break-word;
            word-break: break-word;
            white-space: normal !important;
        }
        .content-item * {
            overflow-wrap: break-word !important;
            word-break: break-word !important;
            white-space: normal !important;
            max-width: 100% !important;
            box-sizing: border-box !important;
        }
        .content-title img, .content-item img {
            max-width: 100% !important;
            height: auto !important;
        }
        .content-title table, .content-item table {
            width: 100% !important;
            display: block;
            overflow-x: auto;
        }
        .content-title pre, .content-item pre,
        .content-title code, .content-item code {
            white-space: pre-wrap !important;
            word-break: break-word !important;
        }
        @media (max-width: 480px) {
            .content-item {
                flex-direction: column !important;
                align-items: flex-start !important;
                gap: 8px !important;
                padding: 6px 0 !important;
            }
            .edit-btn {
                align-self: flex-end !important;
            }
        }
        .edit-fab {
            position: absolute;
            top: 18px;
            right: 24px;
            z-index: 10;
            background: rgb(76, 20, 228);
            color: #fff;
            border-radius: 50%;
            width: 44px;
            height: 44px;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 2px 8px rgba(0,0,0,0.12);
            border: none;
            font-size: 24px;
            transition: background 0.2s, box-shadow 0.2s;
            text-decoration: none;
        }
        .edit-fab:hover {
            background: rgb(139, 4, 121);
            color: #fff;
            box-shadow: 0 4px 16px rgba(0,0,0,0.18);
        }
        @media (max-width: 576px) {
            .edit-fab {
                top: 10px;
                right: 10px;
                width: 38px;
                height: 38px;
                font-size: 20px;
            }
        }
        .tambah-fab {
            position: absolute;
            background: #198754;
            color: #fff;
            border-radius: 50%;
            width: 44px;
            height: 44px;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 2px 8px rgba(0,0,0,0.12);
            border: none;
            font-size: 24px;
            transition: background 0.2s, box-shadow 0.2s;
            text-decoration: none;
        }
        .tambah-fab:hover {
            background: #157347;
            color: #fff;
            box-shadow: 0 4px 16px rgba(0,0,0,0.18);
        }
        @media (max-width: 576px) {
            .tambah-fab {
                width: 38px;
                height: 38px;
                font-size: 20px;
                right: 10px;
                bottom: 10px;
            }
        }
        
        /* Modal Refleksi Styles */
        .modal-xl {
            max-width: 90%;
        }
        
        @media (max-width: 768px) {
            .modal-xl {
                max-width: 95%;
            }
        }
        
        .modal-body {
            max-height: 70vh;
            overflow-y: auto;
        }
        
        .tox-tinymce {
            border-radius: 0.375rem;
            border: 1px solid #ced4da;
        }
        
        .tox-tinymce:focus-within {
            border-color: #667eea;
            box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
        }
        .contoh-action-group {
            display: flex !important;
            flex-direction: row !important;
            align-items: center !important;
            gap: 4px !important;
            position: relative;
        }
        .contoh-action-group .contoh-edit-btn,
        .contoh-action-group .contoh-delete-form {
            display: none !important;
        }
        .contoh-action-group:hover .contoh-edit-btn,
        .contoh-action-group:hover .contoh-delete-form {
            display: inline-block !important;
        }
        .contoh-action-group .btn-outline-primary:hover ~ .contoh-edit-btn,
        .contoh-action-group .btn-outline-primary:hover ~ .contoh-delete-form {
            display: inline-block !important;
        }
        .contoh-card {
            background: rgb(228, 228, 228);
            border: 2px solid rgb(237, 236, 247);
        }
        .contoh-card .card-header {
            background: rgb(5, 5, 54);
            color: #fff !important;
        }
        .contoh-card .card-body {
            color: #222 !important;
        }
        .contoh-card .btn-outline-primary {
            color: #1976d2 !important;
            border-color: #1976d2 !important;
            background: #fff !important;
        }
        .contoh-card .btn-outline-primary:hover {
            background: #1976d2 !important;
            color: #fff !important;
        }
        .main-title-btn-group {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 12px;
            flex-wrap: wrap;
        }
        @media (max-width: 576px) {
            .main-title-btn-group {
                flex-direction: column;
                gap: 6px;
            }
        }

        /* Contoh List Modern Style */
        .contoh-list-item {
            display: flex;
            align-items: flex-start;
            gap: 16px;
            padding: 10px 0;
            border-bottom: 1px solid #eee;
        }
        .contoh-list-icon {
            width: 40px;
            height: 40px;
            background: #7c4dff;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #fff;
            font-size: 24px;
            flex-shrink: 0;
            margin-top: 2px;
            box-shadow: 0 2px 8px rgba(124,77,255,0.08);
        }
        .contoh-list-content {
            flex: 1;
            display: flex;
            flex-direction: column;
            min-width: 0;
        }
        .contoh-list-title {
            font-weight: 600;
            font-size: 1rem;
            color: #222;
            margin-bottom: 2px;
            word-break: break-word;
        }
        .contoh-list-subtext {
            font-size: 0.92rem;
            color: #888;
            margin-bottom: 0;
        }
        .dropdown-menu { z-index: 2000 !important; }
        .contoh-action-group {
            position: relative;
        }
        .contoh-action-group .contoh-edit-btn,
        .contoh-action-group .contoh-delete-form {
            display: none !important;
        }
        .contoh-action-group:hover .contoh-edit-btn,
        .contoh-action-group:hover .contoh-delete-form {
            display: inline-block !important;
        }
        .contoh-clickable:hover {
            background: #f3eaff;
        }
        .content-title-group {
            display: flex;
            align-items: center;
            justify-content: space-between;
            width: 100%;
            position: relative;
        }
        .content-title-actions {
            display: flex;
            gap: 4px;
            opacity: 0;
            transition: opacity 0.2s;
        }
        .content-title-group:hover .content-title-actions {
            opacity: 1;
        }
        .content-title-actions .icon-btn {
            background: none;
            border: none;
            padding: 2px 4px;
            color: #6c757d;
            cursor: pointer;
            font-size: 20px;
            display: flex;
            align-items: center;
            border-radius: 4px;
            transition: background 0.2s, color 0.2s;
        }
        .content-title-actions .icon-btn:hover {
            background: #f3eaff;
            color: #4c14e4;
        }
        .contoh-action-btns {
            position: absolute;
            right: 12px;
            bottom: 8px;
            display: flex;
            gap: 4px;
            opacity: 0;
            transition: opacity 0.2s;
            z-index: 2;
        }
        .contoh-action-group:hover .contoh-action-btns {
            opacity: 1;
        }
        .contoh-action-btns .icon-btn {
            background: none;
            border: none;
            padding: 2px 4px;
            color: #6c757d;
            cursor: pointer;
            font-size: 20px;
            display: flex;
            align-items: center;
            border-radius: 4px;
            transition: background 0.2s, color 0.2s;
        }
        .contoh-action-btns .icon-btn:hover {
            background: #f3eaff;
            color: #4c14e4;
        }
    </style>
</head>
<body>
<?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible fade show m-3" role="alert">
        <?php echo e(session('success')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
<?php endif; ?>
    <div class="main-wrapper">
        <div class="custom-header">
            <div class="main-title-btn-group" style="display:flex; align-items:center; justify-content:center; gap:12px; flex-wrap:wrap;">
                <div class="main-title"><?php echo e($menu->name); ?></div>
            </div>
            <div class="main-desc"><?php echo e($menu->description); ?></div>
            <?php if(auth()->check() && auth()->user()->hasAnyRole(['admin', 'superadmin'])): ?>
                <div id="content-action-bar" class="d-flex gap-2 justify-content-center my-3">
                    <a href="<?php echo e($defaultCategory && $menu ? '/content/create?category_id='.$defaultCategory->id.'&menu_id='.$menu->id : '#'); ?>"
                       class="btn btn-success btn-sm d-flex align-items-center justify-content-center p-2<?php echo e(!$defaultCategory ? ' disabled' : ''); ?>"
                       style="width:40px;height:40px;"
                       <?php echo e(!$defaultCategory ? 'tabindex=-1 aria-disabled=true' : ''); ?>

                       title="Tambah Content"
                       id="btn-tambah-content">
                        <span class="material-icons" style="font-size:22px;">add_circle</span>
                    </a>
                    <a href="<?php echo e($firstContent ? '/content/'.$firstContent->id.'/edit' : '#'); ?>" class="btn btn-primary btn-sm d-flex align-items-center justify-content-center p-2<?php echo e($firstContent ? '' : ' disabled'); ?>" style="width:40px;height:40px;" title="Edit Content" <?php echo e($firstContent ? '' : 'tabindex=\"-1\" aria-disabled=\"true\"'); ?>>
                        <span class="material-icons" style="font-size:22px;">edit</span>
                    </a>
                    <?php if($firstContent): ?>
                        <form action="/content/<?php echo e($firstContent->id); ?>" method="POST" style="display:inline;">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-danger btn-sm d-flex align-items-center justify-content-center p-2" style="width:40px;height:40px;" title="Hapus Content" onclick="return confirm('Yakin ingin menghapus content pertama pada kategori ini?')">
                                <span class="material-icons" style="font-size:22px;">delete</span>
                            </button>
                        </form>
                    <?php else: ?>
                        <button type="button" class="btn btn-danger btn-sm d-flex align-items-center justify-content-center p-2 disabled" style="width:40px;height:40px;" title="Hapus Content" tabindex="-1" aria-disabled="true">
                            <span class="material-icons" style="font-size:22px;">delete</span>
                        </button>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
        <div class="tab-btn-group" style="display:flex; align-items:center; gap:16px;">
            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <span class="tab-btn-wrapper">
                    <button class="tab-btn<?php echo e($i === 0 ? ' active' : ''); ?>" data-category-id="<?php echo e($category->id); ?>"><?php echo e($category->name); ?></button>
                    <?php if(auth()->check() && auth()->user()->hasAnyRole(['admin', 'superadmin'])): ?>
                        <span class="tab-btn-actions">
                            <?php $firstContent = $menu->contents->where('category_id', $category->id)->first(); ?>
                            <a href="<?php echo e($firstContent ? '/content/'.$firstContent->id.'/edit' : '#'); ?>" class="icon-btn<?php echo e($firstContent ? '' : ' disabled'); ?>" title="Edit Content" <?php echo e($firstContent ? '' : 'tabindex=\"-1\" aria-disabled=\"true\"'); ?>>
                                <span class="material-icons">edit</span>
                            </a>
                            <?php if($firstContent): ?>
                                <form action="/content/<?php echo e($firstContent->id); ?>" method="POST" style="display:inline;">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="icon-btn" title="Hapus Content" onclick="return confirm('Yakin ingin menghapus content pertama pada kategori ini?')">
                                        <span class="material-icons">delete</span>
                                    </button>
                                </form>
                            <?php else: ?>
                                <button type="button" class="icon-btn disabled" title="Hapus Content" tabindex="-1" aria-disabled="true">
                                    <span class="material-icons">delete</span>
                                </button>
                            <?php endif; ?>
                        </span>
                    <?php endif; ?>
                </span>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <div class="content-area" style="color:#222; position:relative;">
            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="category-content" id="category-<?php echo e($category->id); ?>" style="display:<?php echo e($i === 0 ? 'block' : 'none'); ?>; position:relative;" data-first-content-id="<?php echo e(optional($menu->contents->where('category_id', $category->id)->first())->id); ?>">
                    <ul>
                        <?php $__currentLoopData = $menu->contents->where('category_id', $category->id); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $content): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="content-item" style="color:#222; flex-direction:column; align-items:stretch; position:relative;">
                                <span class="content-title"><?php echo $content->content; ?></span>
                                <div class="mt-2 position-relative">
                                    <?php if(auth()->check() && auth()->user()->hasAnyRole(['admin', 'superadmin'])): ?>
                                        <div class="d-flex gap-2 mb-2">
                                            <a href="/contoh/create?content_id=<?php echo e($content->id); ?>" class="btn btn-secondary btn-sm">
                                                <span class="material-icons" style="font-size:16px;vertical-align:middle;">add_circle</span>
                                                Tambah Contoh
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                    <?php if($content->contohs && $content->contohs->count()): ?>
                                        <div class="card mb-3 position-relative contoh-card">
                                            <div class="card-header fw-bold">
                                                <?php echo e($content->contohs->count()); ?> Contoh Ice Breaking Reflektif Tujuan Reflektif
                                            </div>
                                            <div class="card-body d-flex flex-column gap-2 position-relative" style="min-height:60px; padding-bottom:56px;">
                                                <?php $__currentLoopData = $content->contohs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contoh): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="contoh-action-group" style="width:100%; position:relative;">
                                                        <div class="contoh-list-item contoh-clickable"
                                                            data-contoh-id="<?php echo e($contoh->id); ?>"
                                                            style="cursor:pointer; width:100%; position:relative;">
                                                            <div class="contoh-list-icon">
                                                                <span class="material-icons">play_circle</span>
                                                            </div>
                                                            <div class="contoh-list-content">
                                                                <div class="contoh-list-title"><?php echo e($contoh->nama); ?></div>
                                                                <div class="contoh-list-subtext"><?php echo e($contoh->fokus_utama); ?></div>
                                                            </div>
                                                            <?php if(auth()->check() && auth()->user()->hasAnyRole(['admin', 'superadmin'])): ?>
                                                                <span class="contoh-action-btns">
                                                                    <a href="/contoh/<?php echo e($contoh->id); ?>/edit" class="icon-btn contoh-edit-link" title="Edit Contoh">
                                                                        <span class="material-icons">edit</span>
                                                                    </a>
                                                                    <form action="/contoh/<?php echo e($contoh->id); ?>" method="POST" style="display:inline;">
                                                                        <?php echo csrf_field(); ?>
                                                                        <?php echo method_field('DELETE'); ?>
                                                                        <button type="submit" class="icon-btn" title="Hapus Contoh" onclick="return confirm('Yakin ingin menghapus contoh ini?')">
                                                                            <span class="material-icons">delete</span>
                                                                        </button>
                                                                    </form>
                                                                </span>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                    <div class="mt-3">
                                        <?php
                                            $refleksi = $content->refleksiUser;
                                        ?>
                                        <a href="#" class="btn btn-secondary btn-refleksi-modal"
                                           data-bs-toggle="modal"
                                           data-bs-target="#refleksiModal"
                                           data-content-id="<?php echo e($content->id); ?>"
                                           <?php if($refleksi): ?>
                                               data-refleksi-id="<?php echo e($refleksi->id); ?>"
                                               data-action="edit"
                                           <?php else: ?>
                                               data-refleksi-id=""
                                               data-action="create"
                                           <?php endif; ?>
                                        >
                                            <span class="material-icons" style="font-size:16px;vertical-align:middle;">add_comment</span>
                                            <?php echo e($refleksi ? 'Edit Refleksi' : 'Refleksi'); ?>

                                        </a>
                                        <?php if($refleksi): ?>
                                            <div class="card mt-2" style="background: #f8f9fa; border: 1px solid #d1e7dd; position:relative;">
                                                <div class="card-header" style="background: #198754; color: #fff; display:flex; justify-content:space-between; align-items:center;">
                                                    Refleksi Anda
                                                </div>
                                                <div class="card-body" style="color: #222;">
                                                    <?php echo $refleksi->refleksi; ?>

                                                </div>
                                            </div>
                                            <?php $feedback = $content->feedback; ?>
                                            <?php if($feedback): ?>
                                                <div class="card mt-2" style="background: #f1f8e9; border: 1px solid #b2dfdb; position:relative;">
                                                    <div class="card-header" style="background: #388e3c; color: #fff; display:flex; justify-content:space-between; align-items:center;">
                                                        Feedback
                                                        <?php if(auth()->check() && auth()->user()->hasAnyRole(['admin', 'superadmin'])): ?>
                                                            <a href="/feedback/<?php echo e($feedback->id); ?>/edit" class="btn btn-sm btn-warning">Edit</a>
                                                        <?php endif; ?>
                                                    </div>
                                                    <div class="card-body" style="color: #222;">
                                                        <?php echo $feedback->feedback; ?>

                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                            <?php if(!$feedback && auth()->check() && auth()->user()->hasAnyRole(['admin', 'superadmin'])): ?>
                                                <a href="/feedback/create?content_id=<?php echo e($content->id); ?>" class="btn btn-sm btn-success mt-2">
                                                    <span class="material-icons" style="font-size:16px;vertical-align:middle;">add</span>
                                                    Tambah Feedback
                                                </a>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <div class="modal fade" id="refleksiModal" tabindex="-1" aria-labelledby="refleksiModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-xl modal-dialog-centered">
            <div class="modal-content">
              <div class="modal-body" id="refleksiModalBody">
                <!-- AJAX content here -->
              </div>
            </div>
          </div>
        </div>
        <!-- Modal untuk detail contoh -->
        <div class="modal fade" id="contohModal" tabindex="-1" aria-labelledby="contohModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="contohModalLabel">Detail Contoh</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body" id="contohModalBody">
                <!-- Data akan diisi via AJAX -->
              </div>
            </div>
          </div>
        </div>
        <script>
        document.addEventListener('DOMContentLoaded', function() {
            document.querySelectorAll('.tab-btn').forEach(function(btn) {
                btn.addEventListener('click', function() {
                    document.querySelectorAll('.tab-btn').forEach(b => b.classList.remove('active'));
                    btn.classList.add('active');
                    var catId = btn.getAttribute('data-category-id');
                    document.querySelectorAll('.category-content').forEach(function(div) {
                        div.style.display = 'none';
                    });
                    document.getElementById('category-' + catId).style.display = 'block';
                });
            });

            // Tambahkan event klik untuk contoh
            document.querySelectorAll('.contoh-list-item').forEach(function(item) {
                item.addEventListener('click', function() {
                    var contohId = item.getAttribute('data-contoh-id');
                    var modal = new bootstrap.Modal(document.getElementById('contohModal'));
                    var modalBody = document.getElementById('contohModalBody');
                    modalBody.innerHTML = 'Loading...';

                    fetch('/contoh/' + contohId)
                        .then(response => response.text())
                        .then(html => {
                            modalBody.innerHTML = html;
                        })
                        .catch(() => {
                            modalBody.innerHTML = 'Gagal memuat data contoh.';
                        });

                    modal.show();
                });
            });

            // Pastikan klik tombol edit contoh tidak trigger modal detail
            document.querySelectorAll('.contoh-edit-link').forEach(function(link) {
                link.addEventListener('click', function(event) {
                    event.stopPropagation();
                });
            });

            // Tambahkan event klik untuk tombol refleksi (buat/edit)
            document.querySelectorAll('.btn-refleksi-modal').forEach(function(btn) {
                btn.addEventListener('click', function(e) {
                    e.preventDefault();
                    var contentId = btn.getAttribute('data-content-id');
                    var refleksiId = btn.getAttribute('data-refleksi-id');
                    var action = btn.getAttribute('data-action');
                    var url = '';

                    if (action === 'edit' && refleksiId) {
                        url = '/refleksi/' + refleksiId + '/edit';
                    } else {
                        url = '/refleksi/create?content_id=' + contentId;
                    }

                    var modalBody = document.getElementById('refleksiModalBody');
                    modalBody.innerHTML = 'Loading...';

                    fetch(url)
                        .then(response => response.text())
                        .then(html => {
                            modalBody.innerHTML = html;
                        })
                        .catch(() => {
                            modalBody.innerHTML = 'Gagal memuat form refleksi.';
                        });
                });
            });

            var btnTambah = document.getElementById('btn-tambah-content');
            if(btnTambah) {
                btnTambah.addEventListener('click', function(e) {
                    if(btnTambah.getAttribute('href') === '#') {
                        e.preventDefault();
                        alert('Tidak ada kategori aktif!');
                    }
                });
            }
        });
        </script>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html> <?php /**PATH /home/rama3823/public_html/tisel/resources/views/menu/show.blade.php ENDPATH**/ ?>