<!DOCTYPE html>
<html>
<head>
    <title>Sign Up</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body {
            background: #f8e9f0;
            font-family: 'Segoe UI', sans-serif;
        }
        .container {
            max-width: 350px;
            margin: 40px auto;
            background: #fff;
            border-radius: 20px;
            box-shadow: 0 4px 24px rgba(0,0,0,0.08);
            padding: 30px 20px 20px 20px;
            position: relative;
        }
        .header {
            background: linear-gradient(135deg, #7b206f 60%, #e94057 100%);
            border-radius: 20px 20px 60px 60px;
            height: 120px;
            position: relative;
            margin: -30px -20px 30px -20px;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
        }
        .avatar {
            width: 60px;
            height: 60px;
            background: #fff;
            border-radius: 50%;
            margin-bottom: 5px;
            margin-top: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 30px;
            color: #e94057;
            box-shadow: 0 2px 8px rgba(0,0,0,0.08);
        }
        .brand {
            color: #fff;
            font-weight: bold;
            font-size: 18px;
            margin-bottom: 10px;
        }
        h2 {
            text-align: center;
            color: #7b206f;
            margin-bottom: 20px;
        }
        .row {
            display: flex;
            gap: 10px;
        }
        .row input {
            flex: 1;
        }
        label {
            font-size: 13px;
            color: #7b206f;
            margin-bottom: 2px;
            display: block;
        }
        input[type="text"], input[type="password"], input[type="email"], input[type="date"] {
            width: 100%;
            padding: 8px 14px; /* tambah padding kanan-kiri */
            margin-bottom: 12px;
            border: 1px solid #e0d3e6;
            border-radius: 8px;
            font-size: 14px;
            background: #f9f6fa;
            box-sizing: border-box; /* pastikan padding tidak bikin mepet */
        }
        .input-group {
            display: flex;
            align-items: center;
            width: 100%;
        }
        .input-group input {
            flex: 1;
            padding-right: 0;
        }
        .toggle-password {
            background: transparent;
            border: none;
            cursor: pointer;
            font-size: 18px;
            color: #7b206f;
            z-index: 2;
            margin-top: -10px;
        }
        button[type="submit"] {
            width: 100%;
            background: linear-gradient(90deg, #7b206f 60%, #e94057 100%);
            color: #fff;
            border: none;
            border-radius: 20px;
            padding: 10px 0;
            font-size: 16px;
            font-weight: bold;
            margin-top: 10px;
            cursor: pointer;
            transition: background 0.2s;
        }
        button[type="submit"]:hover {
            background: linear-gradient(90deg, #e94057 60%, #7b206f 100%);
        }
        .login-link {
            text-align: center;
            margin-top: 12px;
            font-size: 13px;
        }
        .login-link a {
            color: #7b206f;
            text-decoration: none;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <div class="avatar"><img src="/icon/LOGOTISEL-removebg-preview.png" alt="Logo TISEL" style="width:40px; height:40px; border-radius:50%; object-fit:contain;"></div>
            <div class="brand">TISEL</div>
        </div>
        <h2>Sign up</h2>
        <?php if($errors->any()): ?>
            <div style="background:#ffe0e6;color:#b3002d;padding:10px 15px;border-radius:8px;margin-bottom:15px;font-size:14px;">
                <ul style="margin:0;padding-left:18px;">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>
        <form method="POST" action="<?php echo e(route('register')); ?>">
            <?php echo csrf_field(); ?>
            <label>Full Name</label>
            <input type="text" name="name" placeholder="Enter your full name" required>
            <label>Email</label>
            <input type="email" name="email" placeholder="Enter your email" required>
            <label>Password</label>
            <div class="input-group">
                <input type="password" name="password" id="password" placeholder="Enter your password" required>
                <button type="button" class="toggle-password" onclick="togglePassword('password', this)">👁️</button>
            </div>
            <label>Confirm Password</label>
            <div class="input-group">
                <input type="password" name="password_confirmation" id="password_confirmation" placeholder="Confirm your password" required>
                <button type="button" class="toggle-password" onclick="togglePassword('password_confirmation', this)">👁️</button>
            </div>
            <button type="submit">Sign up</button>
        </form>
        <div class="login-link">
            Already have an account? <a href="<?php echo e(route('login')); ?>">Login</a>
        </div>
    </div>
</body>
<script>
function togglePassword(fieldId, btn) {
    const input = document.getElementById(fieldId);
    if (input.type === 'password') {
        input.type = 'text';
        btn.textContent = '🙈';
    } else {
        input.type = 'password';
        btn.textContent = '👁️';
    }
}
</script>
</html> <?php /**PATH /home/rama3823/public_html/tisel/resources/views/auth/register.blade.php ENDPATH**/ ?>