<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Konten</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <style>
        body {
            background: #f4f6fb;
        }
        .edit-content-wrapper {
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .card {
            border-radius: 1rem;
            box-shadow: 0 2px 16px rgba(102,126,234,0.08);
            border: none;
        }
        .card-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border-radius: 1rem 1rem 0 0 !important;
            font-size: 1.2rem;
            font-weight: 600;
        }
        .form-label {
            font-weight: 600;
            color: #495057;
        }
        .form-control:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.15);
        }
        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 0.375rem;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        .btn-primary:hover {
            background: linear-gradient(135deg, #764ba2 0%, #667eea 100%);
        }
        .btn-secondary {
            background: #6c757d;
            border: none;
            border-radius: 0.375rem;
            font-weight: 600;
        }
        .btn-warning {
            background: #ffc107;
            border: none;
            border-radius: 0.375rem;
            font-weight: 600;
            color: #212529;
        }
        .btn:hover {
            opacity: 0.9;
        }
        .invalid-feedback {
            display: block;
        }
        @media (max-width: 768px) {
            .edit-content-wrapper {
                padding: 16px;
            }
            .card {
                border-radius: 0.5rem;
            }
        }
    </style>
</head>
<body>
<div class="edit-content-wrapper">
    <div class="card w-100" style="max-width: 700px;">
        <div class="card-header d-flex justify-content-between align-items-center">
            <span><i class="fas fa-edit me-2"></i>Edit Konten</span>
            <a href="<?php echo e(route('menus.show', $content->menu_id)); ?>" class="btn btn-light btn-sm">Kembali ke Menu</a>
        </div>
        <div class="card-body">
            <?php if($errors->any()): ?>
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>
            <form method="POST" action="<?php echo e(route('content.update', $content->id)); ?>" enctype="multipart/form-data" id="formEditContent">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <?php if(isset($content->menu_id) && $content->menu_id): ?>
                    <input type="hidden" name="title" value="<?php echo e($content->title); ?>">
                    <input type="hidden" name="description" value="<?php echo e($content->description); ?>">
                    <input type="hidden" name="menu_id" value="<?php echo e($content->menu_id); ?>">
                <?php else: ?>
                    <div class="mb-3">
                        <label for="title" class="form-label">Judul <span class="text-danger">*</span></label>
                        <input type="text" class="form-control <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="title" name="title" value="<?php echo e(old('title', $content->title)); ?>" required>
                        <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="mb-3">
                        <label for="description" class="form-label">Deskripsi <span class="text-danger">*</span></label>
                        <textarea class="form-control <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="description" name="description" rows="4" required><?php echo e(old('description', $content->description)); ?></textarea>
                        <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="mb-3">
                        <label for="menu_id" class="form-label">Menu <span class="text-danger">*</span></label>
                        <select class="form-control <?php $__errorArgs = ['menu_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="menu_id" name="menu_id" required>
                            <option value="">Pilih Menu</option>
                            <?php $__currentLoopData = $menus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($menu->id); ?>" <?php echo e(old('menu_id', $content->menu_id) == $menu->id ? 'selected' : ''); ?>><?php echo e($menu->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['menu_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                <?php endif; ?>
                <div class="mb-3">
                    <label for="category_id" class="form-label">Kategori</label>
                    <div class="input-group">
                        <select class="form-control <?php $__errorArgs = ['category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="category_id" name="category_id">
                            <option value="">Pilih Kategori (Opsional)</option>
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($category->id); ?>" <?php echo e(old('category_id', $content->category_id) == $category->id ? 'selected' : ''); ?>><?php echo e($category->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <button type="button" class="btn btn-outline-primary" id="addCategoryBtn" style="margin-left:8px;">Tambah Kategori</button>
                    </div>
                    <?php $__errorArgs = ['category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                <div class="mb-3">
                    <label for="content" class="form-label">Konten <span class="text-danger">*</span></label>
                    <textarea class="form-control <?php $__errorArgs = ['content'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="content" name="content" rows="8" required><?php echo e(old('content', $content->content)); ?></textarea>
                    <?php $__errorArgs = ['content'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                <div class="mb-3">
                    <label for="image" class="form-label">Gambar</label>
                    <?php if($content->image): ?>
                        <div class="mb-2">
                            <img src="<?php echo e(asset('storage/' . $content->image)); ?>" alt="Current Image" class="img-thumbnail" style="max-width: 200px;">
                            <p class="text-muted">Gambar saat ini</p>
                        </div>
                    <?php endif; ?>
                    <input type="file" class="form-control <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="image" name="image" accept="image/*">
                    <small class="form-text text-muted">Biarkan kosong jika tidak ingin mengubah gambar</small>
                    <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                <div class="mb-3">
                    <label for="status" class="form-label">Status <span class="text-danger">*</span></label>
                    <select class="form-control <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="status" name="status" required>
                        <option value="">Pilih Status</option>
                        <option value="draft" <?php echo e(old('status', $content->status) == 'draft' ? 'selected' : ''); ?>>Draft</option>
                        <option value="published" <?php echo e(old('status', $content->status) == 'published' ? 'selected' : ''); ?>>Published</option>
                    </select>
                    <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                <div class="d-flex justify-content-between align-items-center mt-4">
                    <a href="<?php echo e(route('menus.show', $content->menu_id)); ?>" class="btn btn-secondary">Batal</a>
                    <div>
                        <button type="reset" class="btn btn-warning me-2">Reset</button>
                        <button type="submit" class="btn btn-primary">Update Konten</button>
                    </div>
                </div>
            </form>
            <!-- Modal Tambah Kategori -->
            <div class="modal fade" id="addCategoryModal" tabindex="-1" aria-labelledby="addCategoryModalLabel" aria-hidden="true">
              <div class="modal-dialog">
                <div class="modal-content">
                  <div class="modal-header">
                    <h5 class="modal-title" id="addCategoryModalLabel">Tambah Kategori Baru</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                  </div>
                  <div class="modal-body">
                    <div class="mb-3">
                      <label for="newCategoryName" class="form-label">Nama Kategori</label>
                      <input type="text" class="form-control" id="newCategoryName" />
                      <div class="invalid-feedback" id="newCategoryError"></div>
                    </div>
                  </div>
                  <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="button" class="btn btn-primary" id="saveCategoryBtn">Simpan</button>
                  </div>
                </div>
              </div>
            </div>
        </div>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/tinymce@6.8.3/tinymce.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
  tinymce.init({
    selector: '#content',
    height: 600,
    menubar: true,
    plugins: 'lists link image table code media',
    toolbar: 'undo redo | styles | bold italic underline | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image media table | code | customImage customVideo',
    setup: function(editor) {
      editor.ui.registry.addButton('customImage', {
        text: '',
        icon: 'image',
        tooltip: 'Upload & Insert Image',
        onAction: function() {
          openCustomImageModal(editor);
        }
      });
      editor.ui.registry.addButton('customVideo', {
        text: '',
        icon: 'media',
        tooltip: 'Upload & Insert Video',
        onAction: function() {
          openCustomVideoModal(editor);
        }
      });
    }
  });

  function openCustomImageModal(editor) {
    var modal = document.createElement('div');
    modal.style.position = 'fixed';
    modal.style.top = '0';
    modal.style.left = '0';
    modal.style.width = '100vw';
    modal.style.height = '100vh';
    modal.style.background = 'rgba(0,0,0,0.5)';
    modal.style.display = 'flex';
    modal.style.alignItems = 'center';
    modal.style.justifyContent = 'center';
    modal.style.zIndex = '9999';
    modal.innerHTML = `
      <div style="background:#fff;padding:24px;border-radius:8px;min-width:320px;max-width:90vw;text-align:center;">
        <h5>Upload & Preview Image</h5>
        <input type="file" id="customImageInput" accept="image/*" style="margin-bottom:12px;" />
        <div id="customImagePreview" style="margin-bottom:12px;"></div>
        <button id="customImageInsert" class="btn btn-primary" disabled>Insert</button>
        <button id="customImageCancel" class="btn btn-secondary" style="margin-left:8px;">Cancel</button>
      </div>
    `;
    document.body.appendChild(modal);

    var input = modal.querySelector('#customImageInput');
    var preview = modal.querySelector('#customImagePreview');
    var insertBtn = modal.querySelector('#customImageInsert');
    var cancelBtn = modal.querySelector('#customImageCancel');
    var imageData = '';

    input.addEventListener('change', function() {
      var file = this.files[0];
      if (file) {
        var reader = new FileReader();
        reader.onload = function(e) {
          imageData = e.target.result;
          preview.innerHTML = `<img src="${imageData}" style="max-width:200px;max-height:200px;" />`;
          insertBtn.disabled = false;
        };
        reader.readAsDataURL(file);
      }
    });

    insertBtn.addEventListener('click', function() {
      if (imageData) {
        editor.insertContent(`<img src='${imageData}' style='max-width:100%;height:auto;' />`);
        document.body.removeChild(modal);
      }
    });
    cancelBtn.addEventListener('click', function() {
      document.body.removeChild(modal);
    });
  }

  function openCustomVideoModal(editor) {
    var modal = document.createElement('div');
    modal.style.position = 'fixed';
    modal.style.top = '0';
    modal.style.left = '0';
    modal.style.width = '100vw';
    modal.style.height = '100vh';
    modal.style.background = 'rgba(0,0,0,0.5)';
    modal.style.display = 'flex';
    modal.style.alignItems = 'center';
    modal.style.justifyContent = 'center';
    modal.style.zIndex = '9999';
    modal.innerHTML = `
      <div style="background:#fff;padding:24px;border-radius:8px;min-width:320px;max-width:90vw;text-align:center;">
        <h5>Upload & Preview Video</h5>
        <input type="file" id="customVideoInput" accept="video/mp4,video/webm,video/ogg" style="margin-bottom:12px;" />
        <div id="customVideoPreview" style="margin-bottom:12px;"></div>
        <button id="customVideoInsert" class="btn btn-primary" disabled>Insert</button>
        <button id="customVideoCancel" class="btn btn-secondary" style="margin-left:8px;">Cancel</button>
      </div>
    `;
    document.body.appendChild(modal);

    var input = modal.querySelector('#customVideoInput');
    var preview = modal.querySelector('#customVideoPreview');
    var insertBtn = modal.querySelector('#customVideoInsert');
    var cancelBtn = modal.querySelector('#customVideoCancel');
    var videoData = '';

    input.addEventListener('change', function() {
      var file = this.files[0];
      if (file) {
        var reader = new FileReader();
        reader.onload = function(e) {
          videoData = e.target.result;
          preview.innerHTML = `<video src="${videoData}" controls style="max-width:300px;max-height:200px;"></video>`;
          insertBtn.disabled = false;
        };
        reader.readAsDataURL(file);
      }
    });

    insertBtn.addEventListener('click', function() {
      if (videoData) {
        editor.insertContent(`<video src='${videoData}' controls style='max-width:100%;height:auto;'></video>`);
        document.body.removeChild(modal);
      }
    });
    cancelBtn.addEventListener('click', function() {
      document.body.removeChild(modal);
    });
  }
</script>
</body>
</html> <?php /**PATH /home/rama3823/public_html/tisel/resources/views/content/edit.blade.php ENDPATH**/ ?>