<?php $__env->startSection('content'); ?>
<div class="container">
    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>
    
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>Detail Konten</h2>
        <div>
            <a href="<?php echo e(route('content.edit', $content->id)); ?>" class="btn btn-warning">Edit</a>
            <a href="<?php echo e(route('content.index')); ?>" class="btn btn-secondary">Kembali</a>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-md-8">
                    <h4 class="card-title"><?php echo e($content->title); ?></h4>
                    <p class="text-muted mb-3">
                        <small>
                            <i class="fas fa-calendar"></i> <?php echo e($content->created_at->format('d M Y H:i')); ?>

                            <?php if($content->updated_at != $content->created_at): ?>
                                | <i class="fas fa-edit"></i> <?php echo e($content->updated_at->format('d M Y H:i')); ?>

                            <?php endif; ?>
                        </small>
                    </p>
                    
                    <?php if($content->image): ?>
                        <div class="mb-3">
                            <img src="<?php echo e(asset('storage/' . $content->image)); ?>" 
                                 alt="<?php echo e($content->title); ?>" 
                                 class="img-fluid rounded" 
                                 style="max-height: 300px;">
                        </div>
                    <?php endif; ?>
                    
                    <div class="content-body bg-light p-4 rounded shadow-sm mb-4">
                        <pre style="white-space: pre-wrap; word-break: break-word; background: none; border: none; font-size: 1.1rem; font-family: inherit; color: #222;">
<?php echo e(strip_tags($content->content)); ?>

                        </pre>
                    </div>
                </div>
                
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-header">
                            <h6 class="mb-0">Informasi Konten</h6>
                        </div>
                        <div class="card-body">
                            <p><strong>Menu:</strong> <?php echo e($content->menu->name ?? 'Tidak ada menu'); ?></p>
                            <p><strong>Kategori:</strong> <?php echo e($content->category->name ?? 'Tidak ada kategori'); ?></p>
                            <p><strong>Status:</strong> 
                                <span class="badge badge-<?php echo e($content->status == 'published' ? 'success' : 'warning'); ?>">
                                    <?php echo e(ucfirst($content->status)); ?>

                                </span>
                            </p>
                            <p><strong>Urutan:</strong> <?php echo e($content->order ?? '-'); ?></p>
                            
                            <?php if($content->meta_description): ?>
                                <p><strong>Meta Description:</strong></p>
                                <p class="text-muted"><?php echo e($content->meta_description); ?></p>
                            <?php endif; ?>
                            
                            <?php if($content->meta_keywords): ?>
                                <p><strong>Meta Keywords:</strong></p>
                                <p class="text-muted"><?php echo e($content->meta_keywords); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="mt-3">
        <form action="<?php echo e(route('content.destroy', $content->id)); ?>" method="POST" style="display: inline;">
            <?php echo csrf_field(); ?>
            <?php echo method_field('DELETE'); ?>
            <button type="submit" class="btn btn-danger" onclick="return confirm('Apakah Anda yakin ingin menghapus konten ini?')">
                <i class="fas fa-trash"></i> Hapus Konten
            </button>
        </form>
    </div>

    <div class="mt-5">
        <h5>Contoh</h5>
        <?php if($content->contohs->count() > 0): ?>
            <ul class="list-group">
                <?php $__currentLoopData = $content->contohs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contoh): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="list-group-item d-flex justify-content-between align-items-center">
                        <span><?php echo e($contoh->nama); ?></span>
                        <a href="<?php echo e(route('contoh.show', $contoh->id)); ?>" class="btn btn-sm btn-info">Lihat</a>
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        <?php else: ?>
            <div class="text-center text-muted">Belum ada contoh.</div>
        <?php endif; ?>
    </div>
</div>

<style>
.content-body {
    line-height: 1.6;
    font-size: 16px;
}

.content-body img {
    max-width: 100%;
    height: auto;
    border-radius: 8px;
    margin: 10px 0;
}

.content-body h1, .content-body h2, .content-body h3, .content-body h4, .content-body h5, .content-body h6 {
    margin-top: 20px;
    margin-bottom: 10px;
    color: #333;
}

.content-body p {
    margin-bottom: 15px;
}

.content-body ul, .content-body ol {
    margin-bottom: 15px;
    padding-left: 20px;
}

.content-body blockquote {
    border-left: 4px solid #007bff;
    padding-left: 15px;
    margin: 15px 0;
    font-style: italic;
    color: #666;
}
</style>
<?php $__env->stopSection(); ?> <?php /**PATH /home/rama3823/public_html/tisel/resources/views/content/show.blade.php ENDPATH**/ ?>