<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Detail Contoh</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        .card {
            border: none;
            border-radius: 20px;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.1);
            backdrop-filter: blur(10px);
            background: rgba(255, 255, 255, 0.95);
        }
        
        .card-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border-radius: 20px 20px 0 0 !important;
            padding: 1.5rem;
        }
        
        .card-header h5 {
            color: white;
            font-weight: 700;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.3);
        }
        
        .table {
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
            font-size: 1.1rem;
        }
        
        .table-responsive {
            border-radius: 15px;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.15);
        }
        
        .table th {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            font-weight: 600;
            border: none;
            padding: 1.5rem;
            font-size: 1.1rem;
            white-space: nowrap;
            min-width: 200px;
        }
        
        .table td {
            background: rgba(255, 255, 255, 0.95);
            border: none;
            padding: 1.5rem;
            vertical-align: middle;
            font-size: 1rem;
            line-height: 1.6;
        }
        
        .table tbody tr:hover {
            background: rgba(102, 126, 234, 0.1);
            transform: translateY(-2px);
            transition: all 0.3s ease;
        }
        
        .modal-content {
            border-radius: 20px;
            border: none;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.2);
        }
        
        .modal-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border-radius: 20px 20px 0 0;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 10px;
            padding: 10px 20px;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
        }
        
        .btn-danger {
            background: linear-gradient(135deg, #ff6b6b 0%, #ee5a52 100%);
            border: none;
            border-radius: 10px;
            padding: 10px 20px;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        
        .btn-danger:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(255, 107, 107, 0.4);
        }
        
        .btn-secondary {
            background: linear-gradient(135deg, #6c757d 0%, #495057 100%);
            border: none;
            border-radius: 10px;
            padding: 10px 20px;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        
        .btn-secondary:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(108, 117, 125, 0.4);
        }
        
        .text-primary {
            color: #667eea !important;
        }
        
        .bg-light {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;
            color: white !important;
            font-weight: 600 !important;
        }
        
        .border.rounded {
            border-radius: 15px !important;
            border: 2px solid #e9ecef !important;
            background: linear-gradient(135deg, #f8f9fa 0%, #ffffff 100%) !important;
        }
        
        .container {
            padding-top: 2rem;
            padding-bottom: 2rem;
        }
        
        .card-body {
            padding: 2rem;
        }
        
        .modal-body {
            padding: 2rem;
        }
        
        .modal-footer {
            padding: 1.5rem 2rem;
            border-top: 1px solid rgba(102, 126, 234, 0.2);
        }
        
        .fw-bold {
            font-weight: 700 !important;
        }
        
        .mb-3 {
            margin-bottom: 1.5rem !important;
        }
        
        .mb-2 {
            margin-bottom: 1rem !important;
        }
        
        .p-3 {
            padding: 1.5rem !important;
        }
        
        .me-2 {
            margin-right: 0.75rem !important;
        }
        
        .me-1 {
            margin-right: 0.5rem !important;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="mb-0 text-center flex-grow-1">
                            <i class="fas fa-star text-warning me-2"></i><?php echo e($contoh->nama); ?>

                        </h5>
                     
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="table-responsive">
                                    <table class="table table-bordered">
                                        <tbody>
                                     
                                            <tr>
                                                <th class="bg-light">
                                                    <i class="fas fa-bullseye text-primary me-2"></i>Fokus Utama
                                                </th>
                                                <td style="font-weight: 500; color: #2c3e50;"><?php echo e($contoh->fokus_utama); ?></td>
                                            </tr>
                                            <tr>
                                                <th class="bg-light">
                                                    <i class="fas fa-lightbulb text-warning me-2"></i>Aspek Unik
                                                </th>
                                                <td style="font-weight: 500; color: #2c3e50;"><?php echo e($contoh->aspek_unik); ?></td>
                                            </tr>
                                            <tr>
                                                <th class="bg-light">
                                                    <i class="fas fa-file-alt text-info me-2"></i>Isi
                                                </th>
                                                <td><?php echo $contoh->isi; ?></td>
                                            </tr>

                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        
                        
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Delete Confirmation Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">
                        <i class="fas fa-exclamation-triangle text-warning me-2"></i>Konfirmasi Hapus
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>Apakah Anda yakin ingin menghapus contoh "<strong><?php echo e($contoh->nama); ?></strong>"?</p>
                    <p class="text-muted small">Tindakan ini tidak dapat dibatalkan.</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        <i class="fas fa-times me-1"></i>Batal
                    </button>
                    <form action="<?php echo e(route('contoh.destroy', $contoh->id)); ?>" method="POST" class="d-inline">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="submit" class="btn btn-danger">
                            <i class="fas fa-trash me-1"></i>Hapus
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Detail Modal for Quick View -->
    <div class="modal fade" id="detailModal" tabindex="-1" aria-labelledby="detailModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="detailModalLabel">
                        <i class="fas fa-info-circle text-info me-2"></i>Detail Contoh
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="mb-3">
                                <label class="fw-bold text-primary">
                                    <i class="fas fa-star text-warning me-2"></i>Nama Contoh:
                                </label>
                                <p class="mb-2"><?php echo e($contoh->nama); ?></p>
                            </div>
                            
                            <div class="mb-3">
                                <label class="fw-bold text-primary">
                                    <i class="fas fa-bullseye text-primary me-2"></i>Fokus Utama:
                                </label>
                                <p class="mb-2"><?php echo e($contoh->fokus_utama); ?></p>
                            </div>
                            
                            <div class="mb-3">
                                <label class="fw-bold text-primary">
                                    <i class="fas fa-lightbulb text-warning me-2"></i>Aspek Unik:
                                </label>
                                <p class="mb-2"><?php echo e($contoh->aspek_unik); ?></p>
                            </div>
                            
                            <div class="mb-3">
                                <label class="fw-bold text-primary">
                                    <i class="fas fa-file-alt text-info me-2"></i>Isi:
                                </label>
                                <div class="border rounded p-3 bg-light">
                                    <?php echo nl2br(e($contoh->isi)); ?>

                                </div>
                            </div>
                            

                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        <i class="fas fa-times me-1"></i>Tutup
                    </button>
                    <a href="<?php echo e(route('contoh.edit', $contoh->id)); ?>" class="btn btn-primary">
                        <i class="fas fa-edit me-1"></i>Edit
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
    // Auto-show detail modal if needed
    document.addEventListener('DOMContentLoaded', function() {
        // You can trigger the modal automatically by uncommenting the line below
        // var detailModal = new bootstrap.Modal(document.getElementById('detailModal'));
        // detailModal.show();
        
        // Add any additional JavaScript functionality here
        console.log('Contoh detail page loaded');
    });
    </script>
</body>
</html>
<?php /**PATH /home/rama3823/public_html/tisel/resources/views/contoh/show.blade.php ENDPATH**/ ?>