<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\RegisteredUserController;
use App\Http\Controllers\Auth\AuthenticatedSessionController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\MenuController;
use App\Http\Controllers\ContentController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\ContohController;
use App\Http\Controllers\RefleksiController;
use App\Http\Controllers\FeedbackController;

Route::middleware(['auth:sanctum'])->get('/user', function (Request $request) {
    return $request->user();
});

Route::get('/login', function () {
    return response()->json([
        'message' => 'Gunakan metode POST untuk login ke API ini.'
    ], 405);
});

Route::get('/test', function () {
    return response()->json(['message' => 'API test berhasil!']);
});

// Authentication API
Route::post('/register', [RegisteredUserController::class, 'apiRegister']);
Route::post('/login', [AuthenticatedSessionController::class, 'apiLogin']);
Route::post('/logout', [AuthenticatedSessionController::class, 'apiLogout'])->middleware('auth:sanctum');

// User & Profile API
Route::get('/user-data', [ProfileController::class, 'apiGetUserData'])->middleware('auth:sanctum');

// Menu API
Route::get('/menus', [MenuController::class, 'apiIndex']);
Route::get('/menus/{menu}/detail', [MenuController::class, 'apiMenuDetail']);

// Content API - Full CRUD
Route::middleware(['auth:sanctum'])->group(function () {
    Route::get('/contents', [ContentController::class, 'apiIndex']);
    Route::post('/contents', [ContentController::class, 'apiStore']);
    Route::get('/contents/{content}', [ContentController::class, 'apiShow']);
    Route::put('/contents/{content}', [ContentController::class, 'apiUpdate']);
    Route::delete('/contents/{content}', [ContentController::class, 'apiDestroy']);
});

// Category API - Full CRUD
Route::middleware(['auth:sanctum'])->group(function () {
    Route::get('/categories', [CategoryController::class, 'apiIndex']);
    Route::post('/categories', [CategoryController::class, 'apiStore']);
    Route::get('/categories/{category}', [CategoryController::class, 'apiShow']);
    Route::put('/categories/{category}', [CategoryController::class, 'apiUpdate']);
    Route::delete('/categories/{category}', [CategoryController::class, 'apiDestroy']);
});

// Contoh API - Full CRUD
Route::get('/contohs', [ContohController::class, 'apiIndex']);
Route::get('/contohs/{contoh}', [ContohController::class, 'apiShow']);
Route::middleware(['auth:sanctum'])->group(function () {
    Route::post('/contohs', [ContohController::class, 'apiStore']);
    Route::put('/contohs/{contoh}', [ContohController::class, 'apiUpdate']);
    Route::delete('/contohs/{contoh}', [ContohController::class, 'apiDestroy']);
});

// Refleksi API - Full CRUD
Route::get('/refleksis', [RefleksiController::class, 'apiIndex']);
Route::get('/refleksis/{refleksi}', [RefleksiController::class, 'apiShow']);
Route::middleware(['auth:sanctum'])->group(function () {
    Route::post('/refleksis', [RefleksiController::class, 'apiStore']);
    Route::put('/refleksis/{refleksi}', [RefleksiController::class, 'apiUpdate']);
    Route::delete('/refleksis/{refleksi}', [RefleksiController::class, 'apiDestroy']);
});

// Feedback API - Full CRUD
Route::get('/feedbacks', [FeedbackController::class, 'apiIndex']);
Route::get('/feedbacks/{feedback}', [FeedbackController::class, 'apiShow']);
Route::middleware(['auth:sanctum'])->group(function () {
    Route::post('/feedbacks', [FeedbackController::class, 'apiStore']);
    Route::put('/feedbacks/{feedback}', [FeedbackController::class, 'apiUpdate']);
    Route::delete('/feedbacks/{feedback}', [FeedbackController::class, 'apiDestroy']);
});
