<!DOCTYPE html>
<html>
<head>
    <title>Login</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body {
            background: #f8e9ef;
            font-family: 'Segoe UI', sans-serif;
            margin: 0;
            padding: 0;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .login-card {
            background: #fff;
            max-width: 420px;
            width: 100%;
            /* margin: 40px auto; */
            border-radius: 20px;
            box-shadow: 0 4px 24px rgba(0,0,0,0.08);
            overflow: hidden;
        }
        .login-header {
            background: linear-gradient(135deg, #7b206f 60%, #f74b81 100%);
            padding: 40px 0 30px 0;
            text-align: center;
            position: relative;
        }
        .avatar {
            width: 70px;
            height: 70px;
            background: #fff;
            border-radius: 50%;
            margin: 0 auto 10px auto;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 32px;
            color: #7b206f;
            box-shadow: 0 2px 8px rgba(0,0,0,0.08);
        }
        .login-header h2 {
            color: #fff;
            margin: 0;
            font-weight: 600;
            font-size: 2rem;
        }
        .login-form {
            padding: 30px 30px 20px 30px;
        }
        .login-form label {
            font-size: 0.95rem;
            color: #7b206f;
            font-weight: 500;
        }
        .login-form input {
            width: 100%;
            padding: 10px 12px;
            margin: 8px 0 18px 0;
            border: 1px solid #ddd;
            border-radius: 8px;
            font-size: 1rem;
        }
        .login-form button {
            width: 100%;
            padding: 12px;
            background: linear-gradient(90deg, #7b206f 60%, #f74b81 100%);
            color: #fff;
            border: none;
            border-radius: 8px;
            font-size: 1.1rem;
            font-weight: 600;
            cursor: pointer;
            margin-top: 10px;
        }
        .social-login {
            display: flex;
            justify-content: center;
            gap: 18px;
            margin: 18px 0 10px 0;
        }
        .social-btn {
            width: 38px;
            height: 38px;
            border-radius: 50%;
            background: #f1f1f1;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.3rem;
            color: #555;
            border: none;
            cursor: pointer;
            transition: background 0.2s;
        }
        .social-btn:hover {
            background: #e0e0e0;
        }
        .register-link {
            text-align: center;
            margin: 18px 0 10px 0;
            font-size: 0.97rem;
        }
        .register-link a {
            color: #7b206f;
            text-decoration: none;
            font-weight: 600;
        }
    </style>
    <!-- Untuk ikon sosial, gunakan CDN fontawesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <div class="login-card">
        <div class="login-header">
            <div class="avatar">
                <img src="/icon/LOGOTISEL-removebg-preview.png" alt="Logo TISEL" style="width:48px; height:48px; border-radius:50%; object-fit:contain;">
            </div>
            <h2>Login</h2>
        </div>
        @if ($errors->any())
            <div style="color:red; margin: 10px 30px 0 30px; text-align:center; font-weight:bold;">
                {{ $errors->first() }}
            </div>
        @endif
        <form class="login-form" method="POST" action="{{ route('login') }}">
            @csrf
            <label>Email</label>
            <input type="email" name="email" placeholder="Enter your Email" required>
            <label>Password</label>
            <input type="password" name="password" placeholder="Enter your Password" required>
            <button type="submit">Login</button>
            <div class="social-login">
                <button type="button" class="social-btn" title="Login with Google"><i class="fab fa-google"></i></button>
                <button type="button" class="social-btn" title="Login with Twitter"><i class="fab fa-twitter"></i></button>
                <button type="button" class="social-btn" title="Login with Facebook"><i class="fab fa-facebook-f"></i></button>
            </div>
            <div class="register-link">
                Don't have an account? <a href="{{ route('register') }}">signup</a>
            </div>
        </form>
    </div>
</body>
</html> 