<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\Profile;

class ProfileSeeder extends Seeder
{
    public function run(): void
    {
        $users = User::all();
        foreach ($users as $user) {
            Profile::firstOrCreate([
                'user_id' => $user->id,
            ], [
                'full_name' => $user->name,
                'address' => 'Alamat ' . $user->name,
                'phone' => '08123456789',
                'birth_date' => '2000-01-01',
                'foto_profile' => 'https://lh3.googleusercontent.com/a/AAcHTtew1QwFOTO_LINK_CONT0H',
            ]);
        }
    }
} 