<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Menu;

class MenuSeeder extends Seeder
{
    public function run(): void
    {
        // Hapus semua menu lama
        Menu::truncate();

        $menus = [
            [
                'name' => 'Eksplorasi Diri dan Nilai',
                'icon' => 'star',
                'description' => "Eksplorasi Diri dan\nNilai",
                'status' => 1,
            ],
            [
                'name' => 'Peningkatan Kesadaran Sosial dan Empati',
                'icon' => 'volunteer_activism',
                'description' => "Peningkatan Kesadaran Sosial\ndan Empati",
                'status' => 1,
            ],
            [
                'name' => 'Manajemen Diri dan Relasi',
                'icon' => 'groups',
                'description' => "Manajemen Diri dan\nRelasi",
                'status' => 1,
            ],
            [
                'name' => 'Pemecahan Masalah dan Pengambilan Keputusan Etis',
                'icon' => 'help',
                'description' => "Pemecahan Masalah dan Pengambilan\nKeputusan Etis",
                'status' => 1,
            ],
            [
                'name' => 'Aksi Kolaboratif dan Kreatif',
                'icon' => 'handshake',
                'description' => "Aksi Kolaboratif\ndan Kreatif",
                'status' => 1,
            ],
            [
                'name' => 'Refleksi Personal dan Profesional',
                'icon' => 'self_improvement',
                'description' => "Refleksi Personal\ndan Profesional",
                'status' => 1,
            ],
        ];
        foreach ($menus as $menu) {
            Menu::create($menu);
        }
    }
} 