<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Content;
use App\Models\User;
use App\Models\Menu;
use App\Models\Category;

class ContentSeeder extends Seeder
{
    public function run(): void
    {
        // Hapus semua konten lama
        Content::truncate();

        $users = User::all();
        $menus = Menu::all();

        if ($users->isEmpty() || $menus->isEmpty()) {
            return;
        }

        foreach ($menus as $menu) {
            // Ambil 3 kategori milik menu ini
            $categories = Category::where('name', 'like', '%'.$menu->name)->take(3)->get();
            foreach ($categories as $i => $category) {
                Content::create([
                    'title' => 'Materi ' . ($i+1) . ' - ' . $menu->name,
                    'description' => 'Deskripsi materi ' . ($i+1) . ' untuk menu ' . $menu->name,
                    'content' => '<p style="color:#222;">Isi materi ' . ($i+1) . ' untuk menu ' . $menu->name . ' (warna hitam)</p>',
                    'status' => 'published',
                    'category_id' => $category->id,
                    'menu_id' => $menu->id,
                    'user_id' => $users->first()->id,
                ]);
            }
        }
    }
} 