<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Category;
use App\Models\Menu;
use Illuminate\Support\Str;

class CategorySeeder extends Seeder
{
    public function run(): void
    {
        // Hapus semua kategori lama
        Category::truncate();

        $menus = Menu::all();
        foreach ($menus as $menu) {
            for ($i = 1; $i <= 3; $i++) {
                Category::create([
                    'name' => 'Kategori ' . $i . ' ' . $menu->name,
                    'slug' => Str::slug('Kategori ' . $i . ' ' . $menu->name),
                    'description' => 'Kategori ' . $i . ' untuk menu ' . $menu->name,
                ]);
            }
        }
    }
} 