<?php

namespace App\Policies;

use App\Models\User;
use App\Models\Refleksi;

class RefleksiPolicy
{
    /**
     * Determine if the given refleksi can be updated by the user.
     */
    public function update(User $user, Refleksi $refleksi)
    {
        // Hanya pemilik atau admin/superadmin yang boleh edit
        return $user->id === $refleksi->user_id
            || ($user->hasRole('admin') || $user->hasRole('superadmin'));
    }
} 