<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Content extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'description',
        'content',
        'image',
        'category_id',
        'status',
        'menu_id',
        'user_id'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function menu()
    {
        return $this->belongsTo(Menu::class);
    }

    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    public function contohs()
    {
        return $this->hasMany(Contoh::class);
    }

    public function refleksiUser()
    {
        return $this->hasOne(\App\Models\Refleksi::class)->where('user_id', auth()->id());
    }

    public function feedback()
    {
        return $this->hasOne(\App\Models\Feedback::class);
    }
} 