<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\Profile;

class ProfileController extends Controller
{
    public function update(Request $request)
    {
        $user = Auth::user();
        $data = $request->validate([
            'full_name' => 'required|string|max:255',
            'address' => 'nullable|string|max:255',
            'phone' => 'nullable|string|max:50',
            'birth_date' => 'nullable|date',
        ]);
        $profile = $user->profile;
        if (!$profile) {
            $profile = new Profile(['user_id' => $user->id]);
        }
        $profile->fill($data);
        $profile->user_id = $user->id;
        $profile->save();
        return redirect()->route('profile')->with('success', 'Profile berhasil diupdate');
    }

    public function apiGetUserData(Request $request)
    {
        $user = Auth::user();
        
        $userData = [
            'id' => $user->id,
            'name' => $user->name,
            'email' => $user->email,
            'email_verified_at' => $user->email_verified_at,
            'created_at' => $user->created_at,
            'updated_at' => $user->updated_at,
            'profile' => null,
            'roles' => $user->roles->map(function($role) {
                return [
                    'id' => $role->id,
                    'name' => $role->name,
                    'description' => $role->description
                ];
            })
        ];

        if ($user->profile) {
            $userData['profile'] = [
                'id' => $user->profile->id,
                'full_name' => $user->profile->full_name,
                'address' => $user->profile->address,
                'phone' => $user->profile->phone,
                'birth_date' => $user->profile->birth_date,
                'created_at' => $user->profile->created_at,
                'updated_at' => $user->profile->updated_at
            ];
        }

        return response()->json([
            'success' => true,
            'message' => 'Data user berhasil diambil',
            'data' => $userData
        ]);
    }

    public function edit()
    {
        $user = Auth::user();
        $profile = $user->profile;
        return view('profile.edit-profile', compact('profile'));
    }
}
