<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Feedback;
use App\Models\Content;

class FeedbackController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(Request $request)
    {
        $content_id = $request->get('content_id');
        return view('feedback.create', compact('content_id'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validated = $request->validate([
            'content_id' => 'required|exists:contents,id',
            'feedback' => 'required|string',
        ]);
        $feedback = Feedback::create($validated);
        $menuId = $feedback->content->menu_id;
        return redirect()->route('menus.show', $menuId)->with('success', 'Feedback berhasil ditambahkan!');
    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        $feedback = Feedback::findOrFail($id);
        return view('feedback.show', compact('feedback'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        $feedback = Feedback::findOrFail($id);
        return view('feedback.edit', compact('feedback'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        $feedback = Feedback::findOrFail($id);
        $validated = $request->validate([
            'feedback' => 'required|string',
        ]);
        $feedback->update($validated);
        $menuId = $feedback->content->menu_id;
        return redirect()->route('menus.show', $menuId)->with('success', 'Feedback berhasil diupdate!');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }

    // ========== API METHODS ==========

    /**
     * API: Get all feedback
     */
    public function apiIndex()
    {
        $feedback = Feedback::with('content')->latest()->get();
        return response()->json([
            'success' => true,
            'data' => $feedback
        ]);
    }

    /**
     * API: Store new feedback
     */
    public function apiStore(Request $request)
    {
        $request->validate([
            'content_id' => 'required|exists:contents,id',
            'feedback' => 'required|string',
        ]);

        $feedback = Feedback::create($request->only(['content_id', 'feedback']));
        $feedback->load('content');

        return response()->json([
            'success' => true,
            'message' => 'Feedback created successfully',
            'data' => $feedback
        ], 201);
    }

    /**
     * API: Get specific feedback
     */
    public function apiShow(Feedback $feedback)
    {
        $feedback->load('content');
        return response()->json([
            'success' => true,
            'data' => $feedback
        ]);
    }

    /**
     * API: Update feedback
     */
    public function apiUpdate(Request $request, Feedback $feedback)
    {
        $request->validate([
            'feedback' => 'required|string',
        ]);

        $feedback->update($request->only(['feedback']));
        $feedback->load('content');

        return response()->json([
            'success' => true,
            'message' => 'Feedback updated successfully',
            'data' => $feedback
        ]);
    }

    /**
     * API: Delete feedback
     */
    public function apiDestroy(Feedback $feedback)
    {
        $feedback->delete();

        return response()->json([
            'success' => true,
            'message' => 'Feedback deleted successfully'
        ]);
    }
}
