<?php

namespace App\Http\Controllers;

use App\Models\Content;
use App\Models\User;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function index()
    {
        $totalContent = Content::count();
        $publishedContent = Content::where('status', 'published')->count();
        $draftContent = Content::where('status', 'draft')->count();
        $totalUsers = User::count();
        $recentContent = Content::latest()->take(5)->get();

        return view('dashboard', compact('totalContent', 'publishedContent', 'draftContent', 'totalUsers', 'recentContent'));
    }
} 