# TISEL API Documentation

## Base URL
```
http://yourdomain.com/api
```

## Authentication
Most endpoints require authentication using Laravel Sanctum. Include the token in the Authorization header:
```
Authorization: Bearer {your_token}
```

---

## 🔐 Authentication Endpoints

### Register User
```http
POST /api/register
```

**Request Body:**
```json
{
    "name": "John Doe",
    "email": "john@example.com",
    "password": "password123"
}
```

**Response:**
```json
{
    "user": {
        "id": 1,
        "name": "John Doe",
        "email": "john@example.com",
        "created_at": "2024-01-01T00:00:00.000000Z",
        "updated_at": "2024-01-01T00:00:00.000000Z"
    },
    "token": "1|abc123..."
}
```

### Login User
```http
POST /api/login
```

**Request Body:**
```json
{
    "email": "john@example.com",
    "password": "password123"
}
```

**Response:**
```json
{
    "token": "1|abc123...",
    "id": 1,
    "full_name": "John Doe",
    "foto_profile": "http://domain.com/storage/profile.jpg"
}
```

### Logout User
```http
POST /api/logout
```

**Headers:**
```
Authorization: Bearer {token}
```

**Response:**
```json
{
    "message": "Logged out"
}
```

### Get Current User
```http
GET /api/user
```

**Headers:**
```
Authorization: Bearer {token}
```

**Response:**
```json
{
    "id": 1,
    "name": "John Doe",
    "email": "john@example.com",
    "email_verified_at": "2024-01-01T00:00:00.000000Z",
    "created_at": "2024-01-01T00:00:00.000000Z",
    "updated_at": "2024-01-01T00:00:00.000000Z"
}
```

### Get User Data with Profile
```http
GET /api/user-data
```

**Headers:**
```
Authorization: Bearer {token}
```

**Response:**
```json
{
    "success": true,
    "message": "Data user berhasil diambil",
    "data": {
        "id": 1,
        "name": "John Doe",
        "email": "john@example.com",
        "profile": {
            "id": 1,
            "full_name": "John Doe",
            "address": "Jakarta",
            "phone": "08123456789",
            "birth_date": "1990-01-01"
        },
        "roles": [
            {
                "id": 1,
                "name": "user",
                "description": "Regular user"
            }
        ]
    }
}
```

---

## 📋 Menu Endpoints

### Get All Menus
```http
GET /api/menus
```

**Response:**
```json
{
    "data": [
        {
            "id": 1,
            "name": "Menu 1",
            "description": "Description",
            "icon": "http://domain.com/storage/menu_icons/icon.png",
            "status": 1,
            "created_at": "2024-01-01T00:00:00.000000Z",
            "updated_at": "2024-01-01T00:00:00.000000Z"
        }
    ]
}
```

### Get Menu Detail with Categories and Contents
```http
GET /api/menus/{menu_id}/detail
```

**Response:**
```json
{
    "menu": {
        "id": 1,
        "name": "Menu 1",
        "description": "Description",
        "icon": "icon.png",
        "status": 1
    },
    "categories": [
        {
            "id": 1,
            "name": "Category 1",
            "description": "Category description",
            "contents": [
                {
                    "id": 1,
                    "title": "Content Title",
                    "description": "Content description",
                    "content": "Content body",
                    "status": "published"
                }
            ]
        }
    ]
}
```

---

## 📄 Content Endpoints

### Get All Contents
```http
GET /api/contents
```

**Headers:**
```
Authorization: Bearer {token}
```

**Response:**
```json
{
    "success": true,
    "data": [
        {
            "id": 1,
            "title": "Content Title",
            "description": "Description",
            "content": "Content body",
            "menu_id": 1,
            "category_id": 1,
            "status": "published",
            "image": "content/image.jpg",
            "user_id": 1,
            "menu": {...},
            "category": {...},
            "user": {...}
        }
    ]
}
```

### Create Content
```http
POST /api/contents
```

**Headers:**
```
Authorization: Bearer {token}
Content-Type: multipart/form-data
```

**Request Body:**
```json
{
    "title": "Content Title",
    "description": "Description",
    "content": "Content body",
    "menu_id": 1,
    "category_id": 1,
    "status": "published",
    "image": "file"
}
```

**Response:**
```json
{
    "success": true,
    "message": "Content created successfully",
    "data": {
        "id": 1,
        "title": "Content Title",
        "description": "Description",
        "content": "Content body",
        "menu_id": 1,
        "category_id": 1,
        "status": "published",
        "image": "content/image.jpg",
        "user_id": 1,
        "menu": {...},
        "category": {...},
        "user": {...}
    }
}
```

### Get Specific Content
```http
GET /api/contents/{content_id}
```

**Headers:**
```
Authorization: Bearer {token}
```

**Response:**
```json
{
    "success": true,
    "data": {
        "id": 1,
        "title": "Content Title",
        "description": "Description",
        "content": "Content body",
        "menu_id": 1,
        "category_id": 1,
        "status": "published",
        "image": "content/image.jpg",
        "user_id": 1,
        "menu": {...},
        "category": {...},
        "user": {...}
    }
}
```

### Update Content
```http
PUT /api/contents/{content_id}
```

**Headers:**
```
Authorization: Bearer {token}
Content-Type: multipart/form-data
```

**Request Body:**
```json
{
    "title": "Updated Title",
    "description": "Updated Description",
    "content": "Updated content body",
    "menu_id": 1,
    "category_id": 1,
    "status": "published",
    "image": "file"
}
```

**Response:**
```json
{
    "success": true,
    "message": "Content updated successfully",
    "data": {
        "id": 1,
        "title": "Updated Title",
        "description": "Updated Description",
        "content": "Updated content body",
        "menu_id": 1,
        "category_id": 1,
        "status": "published",
        "image": "content/new-image.jpg",
        "user_id": 1,
        "menu": {...},
        "category": {...},
        "user": {...}
    }
}
```

### Delete Content
```http
DELETE /api/contents/{content_id}
```

**Headers:**
```
Authorization: Bearer {token}
```

**Response:**
```json
{
    "success": true,
    "message": "Content deleted successfully"
}
```

---

## 📂 Category Endpoints

### Get All Categories
```http
GET /api/categories
```

**Headers:**
```
Authorization: Bearer {token}
```

**Response:**
```json
{
    "success": true,
    "data": [
        {
            "id": 1,
            "name": "Category 1",
            "slug": "category-1",
            "description": "Category description",
            "created_at": "2024-01-01T00:00:00.000000Z",
            "updated_at": "2024-01-01T00:00:00.000000Z",
            "contents": [...]
        }
    ]
}
```

### Create Category
```http
POST /api/categories
```

**Headers:**
```
Authorization: Bearer {token}
```

**Request Body:**
```json
{
    "name": "New Category",
    "description": "Category description"
}
```

**Response:**
```json
{
    "success": true,
    "message": "Category created successfully",
    "data": {
        "id": 1,
        "name": "New Category",
        "slug": "new-category",
        "description": "Category description",
        "created_at": "2024-01-01T00:00:00.000000Z",
        "updated_at": "2024-01-01T00:00:00.000000Z"
    }
}
```

### Get Specific Category
```http
GET /api/categories/{category_id}
```

**Headers:**
```
Authorization: Bearer {token}
```

**Response:**
```json
{
    "success": true,
    "data": {
        "id": 1,
        "name": "Category 1",
        "slug": "category-1",
        "description": "Category description",
        "created_at": "2024-01-01T00:00:00.000000Z",
        "updated_at": "2024-01-01T00:00:00.000000Z",
        "contents": [...]
    }
}
```

### Update Category
```http
PUT /api/categories/{category_id}
```

**Headers:**
```
Authorization: Bearer {token}
```

**Request Body:**
```json
{
    "name": "Updated Category",
    "description": "Updated description"
}
```

**Response:**
```json
{
    "success": true,
    "message": "Category updated successfully",
    "data": {
        "id": 1,
        "name": "Updated Category",
        "slug": "updated-category",
        "description": "Updated description",
        "created_at": "2024-01-01T00:00:00.000000Z",
        "updated_at": "2024-01-01T00:00:00.000000Z"
    }
}
```

### Delete Category
```http
DELETE /api/categories/{category_id}
```

**Headers:**
```
Authorization: Bearer {token}
```

**Response:**
```json
{
    "success": true,
    "message": "Category deleted successfully"
}
```

**Error Response (if category has contents):**
```json
{
    "success": false,
    "message": "Cannot delete category that has contents"
}
```

---

## 📝 Contoh Endpoints

### Get All Contoh
```http
GET /api/contoh
```

**Headers:**
```
Authorization: Bearer {token}
```

**Response:**
```json
{
    "success": true,
    "data": [
        {
            "id": 1,
            "nama": "Contoh 1",
            "fokus_utama": "Fokus utama",
            "aspek_unik": "Aspek unik",
            "isi": "Isi contoh",
            "content_id": 1,
            "created_at": "2024-01-01T00:00:00.000000Z",
            "updated_at": "2024-01-01T00:00:00.000000Z",
            "content": {...}
        }
    ]
}
```

### Create Contoh
```http
POST /api/contoh
```

**Headers:**
```
Authorization: Bearer {token}
```

**Request Body:**
```json
{
    "nama": "Contoh Baru",
    "fokus_utama": "Fokus utama",
    "aspek_unik": "Aspek unik",
    "isi": "Isi contoh",
    "content_id": 1
}
```

**Response:**
```json
{
    "success": true,
    "message": "Contoh created successfully",
    "data": {
        "id": 1,
        "nama": "Contoh Baru",
        "fokus_utama": "Fokus utama",
        "aspek_unik": "Aspek unik",
        "isi": "Isi contoh",
        "content_id": 1,
        "created_at": "2024-01-01T00:00:00.000000Z",
        "updated_at": "2024-01-01T00:00:00.000000Z",
        "content": {...}
    }
}
```

### Get Specific Contoh
```http
GET /api/contoh/{contoh_id}
```

**Headers:**
```
Authorization: Bearer {token}
```

**Response:**
```json
{
    "success": true,
    "data": {
        "id": 1,
        "nama": "Contoh 1",
        "fokus_utama": "Fokus utama",
        "aspek_unik": "Aspek unik",
        "isi": "Isi contoh",
        "content_id": 1,
        "created_at": "2024-01-01T00:00:00.000000Z",
        "updated_at": "2024-01-01T00:00:00.000000Z",
        "content": {...}
    }
}
```

### Update Contoh
```http
PUT /api/contoh/{contoh_id}
```

**Headers:**
```
Authorization: Bearer {token}
```

**Request Body:**
```json
{
    "nama": "Contoh Updated",
    "fokus_utama": "Fokus utama updated",
    "aspek_unik": "Aspek unik updated",
    "isi": "Isi contoh updated"
}
```

**Response:**
```json
{
    "success": true,
    "message": "Contoh updated successfully",
    "data": {
        "id": 1,
        "nama": "Contoh Updated",
        "fokus_utama": "Fokus utama updated",
        "aspek_unik": "Aspek unik updated",
        "isi": "Isi contoh updated",
        "content_id": 1,
        "created_at": "2024-01-01T00:00:00.000000Z",
        "updated_at": "2024-01-01T00:00:00.000000Z",
        "content": {...}
    }
}
```

### Delete Contoh
```http
DELETE /api/contoh/{contoh_id}
```

**Headers:**
```
Authorization: Bearer {token}
```

**Response:**
```json
{
    "success": true,
    "message": "Contoh deleted successfully"
}
```

---

## 🤔 Refleksi Endpoints

### Get All Refleksi
```http
GET /api/refleksi
```

**Headers:**
```
Authorization: Bearer {token}
```

**Response:**
```json
{
    "success": true,
    "data": [
        {
            "id": 1,
            "content_id": 1,
            "refleksi": "Refleksi text",
            "user_id": 1,
            "created_at": "2024-01-01T00:00:00.000000Z",
            "updated_at": "2024-01-01T00:00:00.000000Z",
            "content": {...},
            "user": {...}
        }
    ]
}
```

### Create Refleksi
```http
POST /api/refleksi
```

**Headers:**
```
Authorization: Bearer {token}
```

**Request Body:**
```json
{
    "content_id": 1,
    "refleksi": "Refleksi text"
}
```

**Response:**
```json
{
    "success": true,
    "message": "Refleksi created successfully",
    "data": {
        "id": 1,
        "content_id": 1,
        "refleksi": "Refleksi text",
        "user_id": 1,
        "created_at": "2024-01-01T00:00:00.000000Z",
        "updated_at": "2024-01-01T00:00:00.000000Z",
        "content": {...},
        "user": {...}
    }
}
```

### Get Specific Refleksi
```http
GET /api/refleksi/{refleksi_id}
```

**Headers:**
```
Authorization: Bearer {token}
```

**Response:**
```json
{
    "success": true,
    "data": {
        "id": 1,
        "content_id": 1,
        "refleksi": "Refleksi text",
        "user_id": 1,
        "created_at": "2024-01-01T00:00:00.000000Z",
        "updated_at": "2024-01-01T00:00:00.000000Z",
        "content": {...},
        "user": {...}
    }
}
```

### Update Refleksi
```http
PUT /api/refleksi/{refleksi_id}
```

**Headers:**
```
Authorization: Bearer {token}
```

**Request Body:**
```json
{
    "refleksi": "Updated refleksi text"
}
```

**Response:**
```json
{
    "success": true,
    "message": "Refleksi updated successfully",
    "data": {
        "id": 1,
        "content_id": 1,
        "refleksi": "Updated refleksi text",
        "user_id": 1,
        "created_at": "2024-01-01T00:00:00.000000Z",
        "updated_at": "2024-01-01T00:00:00.000000Z",
        "content": {...},
        "user": {...}
    }
}
```

**Error Response (if not authorized):**
```json
{
    "success": false,
    "message": "Unauthorized to update this refleksi"
}
```

### Delete Refleksi
```http
DELETE /api/refleksi/{refleksi_id}
```

**Headers:**
```
Authorization: Bearer {token}
```

**Response:**
```json
{
    "success": true,
    "message": "Refleksi deleted successfully"
}
```

**Error Response (if not authorized):**
```json
{
    "success": false,
    "message": "Unauthorized to delete this refleksi"
}
```

---

## 💬 Feedback Endpoints

### Get All Feedback
```http
GET /api/feedback
```

**Headers:**
```
Authorization: Bearer {token}
```

**Response:**
```json
{
    "success": true,
    "data": [
        {
            "id": 1,
            "content_id": 1,
            "feedback": "Feedback text",
            "created_at": "2024-01-01T00:00:00.000000Z",
            "updated_at": "2024-01-01T00:00:00.000000Z",
            "content": {...}
        }
    ]
}
```

### Create Feedback
```http
POST /api/feedback
```

**Headers:**
```
Authorization: Bearer {token}
```

**Request Body:**
```json
{
    "content_id": 1,
    "feedback": "Feedback text"
}
```

**Response:**
```json
{
    "success": true,
    "message": "Feedback created successfully",
    "data": {
        "id": 1,
        "content_id": 1,
        "feedback": "Feedback text",
        "created_at": "2024-01-01T00:00:00.000000Z",
        "updated_at": "2024-01-01T00:00:00.000000Z",
        "content": {...}
    }
}
```

### Get Specific Feedback
```http
GET /api/feedback/{feedback_id}
```

**Headers:**
```
Authorization: Bearer {token}
```

**Response:**
```json
{
    "success": true,
    "data": {
        "id": 1,
        "content_id": 1,
        "feedback": "Feedback text",
        "created_at": "2024-01-01T00:00:00.000000Z",
        "updated_at": "2024-01-01T00:00:00.000000Z",
        "content": {...}
    }
}
```

### Update Feedback
```http
PUT /api/feedback/{feedback_id}
```

**Headers:**
```
Authorization: Bearer {token}
```

**Request Body:**
```json
{
    "feedback": "Updated feedback text"
}
```

**Response:**
```json
{
    "success": true,
    "message": "Feedback updated successfully",
    "data": {
        "id": 1,
        "content_id": 1,
        "feedback": "Updated feedback text",
        "created_at": "2024-01-01T00:00:00.000000Z",
        "updated_at": "2024-01-01T00:00:00.000000Z",
        "content": {...}
    }
}
```

### Delete Feedback
```http
DELETE /api/feedback/{feedback_id}
```

**Headers:**
```
Authorization: Bearer {token}
```

**Response:**
```json
{
    "success": true,
    "message": "Feedback deleted successfully"
}
```

---

## 📊 Status Codes

- `200` - Success
- `201` - Created
- `400` - Bad Request
- `401` - Unauthorized
- `403` - Forbidden
- `404` - Not Found
- `422` - Validation Error
- `500` - Server Error

---

## 🔧 Error Responses

### Validation Error (422)
```json
{
    "message": "The given data was invalid.",
    "errors": {
        "field_name": [
            "The field name field is required."
        ]
    }
}
```

### Unauthorized (401)
```json
{
    "message": "Unauthenticated."
}
```

### Not Found (404)
```json
{
    "message": "No query results for model [App\\Models\\ModelName] 1"
}
```

---

## 📝 Notes

1. **Authentication**: Most endpoints require authentication. Include the Bearer token in the Authorization header.
2. **File Uploads**: For endpoints that accept file uploads, use `multipart/form-data` content type.
3. **Pagination**: Currently, all list endpoints return all data. Consider implementing pagination for large datasets.
4. **Authorization**: Refleksi endpoints check if the user owns the resource before allowing updates/deletes.
5. **Category Deletion**: Categories cannot be deleted if they have associated contents.
6. **Image Storage**: Images are stored in the `public/content` directory and accessible via `/storage/content/` URL. 